--
-- common ui functions that can be included using LuaInclude to any file
--


-- simple panel transition. fade it quicly in and move it a bit in x axis
-- fader is the big background rectangle that's usually darkening the screens 
-- below to make this one stand out better.
function DoPanelTransition (fader, panel)

	-- smooth the transition a bit with sin. otherwise it'd be simple linear 0 -> 1, 1 -> 0
	trans = math.sin (0.5*3.1415926535 * GetActiveScreenTransPhase ());
	
	-- if the screen is leaving (vs. appearing/enterin), we'll move it to another dir
	if (IsScreenLeaving ()) then
		SetProperty ("" .. panel .. ":position_offset.x", (1-trans) * 50);
	else
		SetProperty ("" .. panel .. ":position_offset.x", (trans-1) * 50);	
	end;

	
	SetProperty ("" .. panel .. ":alpha", trans);
	--SetProperty ("" .. panel .. ":scale", 1 + 0.15 * (1-trans));

	SetProperty ("" .. fader .. ":alpha", trans);

end;

-- vista style transition :)
function DoPanelTransition2 (fader, panel)

	trans = math.sin (0.5*3.1415926535 * GetActiveScreenTransPhase ());

	SetProperty ("" .. panel .. ":position_offset.y", (1-trans) * 10);
	SetProperty ("" .. panel .. ":alpha", trans);
	SetProperty ("" .. panel .. ":scale", 1 + 0.15 * (1-trans));

	SetProperty ("" .. fader .. ":alpha", trans);

end;